/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.crafting.ICraftingSimulationRequester;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftJob
implements ILuaCallback {
    public static final String EVENT = "crafting";
    private final IComputerAccess computer;
    private final IGridNode node;
    private final IActionSource source;
    private final ICraftingSimulationRequester requester;
    private final ICraftingCPU target;
    private final AEKey item;
    private final long amount;
    private final Level world;
    private Future<ICraftingPlan> futureJob;
    private boolean startedCrafting = false;
    private MethodResult result;
    private LuaException exception;

    public CraftJob(Level world, IComputerAccess computer, IGridNode node, AEKey item, long amount, IActionSource source, ICraftingSimulationRequester requester, ICraftingCPU target) {
        this.computer = computer;
        this.node = node;
        this.world = world;
        this.source = source;
        this.item = item;
        this.amount = amount;
        this.requester = requester;
        this.target = target;
    }

    protected void fireEvent(boolean success, @Nullable String exception) {
        this.result = MethodResult.of((Object[])new Object[]{success, exception});
        this.exception = new LuaException(exception);
        this.computer.queueEvent(EVENT, new Object[]{success, exception});
    }

    protected void fireNotConnected() {
        this.fireEvent(false, "not connected");
    }

    public void setStartedCrafting(boolean startedCrafting) {
        this.startedCrafting = startedCrafting;
    }

    public boolean isCraftingStarted() {
        return this.startedCrafting;
    }

    public void startCrafting() {
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            this.fireNotConnected();
            return;
        }
        IStorageService storage = (IStorageService)grid.getService(IStorageService.class);
        ICraftingService crafting = (ICraftingService)grid.getService(ICraftingService.class);
        MEStorage monitor = storage.getInventory();
        if (this.item == null) {
            AdvancedPeripherals.debug("Could not get AEItem from monitor", org.apache.logging.log4j.Level.FATAL);
            return;
        }
        if (!crafting.isCraftable(this.item)) {
            this.fireEvent(false, this.item.getId().toString() + " is not craftable");
            return;
        }
        this.futureJob = crafting.beginCraftingCalculation(this.world, this.requester, this.item, this.amount, CalculationStrategy.REPORT_MISSING_ITEMS);
        this.fireEvent(true, "Started calculation of the recipe. After it's finished, the system will start crafting the item.");
    }

    public void maybeCraft() {
        ICraftingPlan job;
        if (this.startedCrafting || this.futureJob == null || !this.futureJob.isDone()) {
            return;
        }
        try {
            job = this.futureJob.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            AdvancedPeripherals.debug("Tried to get job, but job calculation is not done. Should be done.", org.apache.logging.log4j.Level.FATAL);
            ex.printStackTrace();
            return;
        }
        if (job == null) {
            AdvancedPeripherals.debug("Job is null, should not be null.", org.apache.logging.log4j.Level.FATAL);
            return;
        }
        this.setStartedCrafting(true);
        if (job.simulation()) {
            return;
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            return;
        }
        ICraftingService crafting = (ICraftingService)grid.getService(ICraftingService.class);
        crafting.submitJob(job, null, this.target, false, this.source);
        this.futureJob = null;
    }

    @NotNull
    public MethodResult resume(Object[] objects) {
        if (this.result != null) {
            return this.result;
        }
        if (this.exception != null) {
            return MethodResult.of((Object)this.exception);
        }
        return MethodResult.of();
    }
}

